//
//  GSCustomProperty.h
//  GlyphsCore
//
//  Created by Georg Seifert on 30.11.12.
//  Copyright (c) 2012 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
@class GSInstance;
@interface GSCustomProperty : NSObject {
	NSString * _name;
	id _value;
	GSInstance * __unsafe_unretained_parent;
}
- (id) initWithName:(NSString*) Name value:(id) Value parent:(GSInstance*) Parent;
@property (unsafe_unretained, nonatomic) GSInstance* parent;
@property (nonatomic, strong) NSString* name;
@property (nonatomic, strong) id value;
+ (NSColor*) colorFromValue:(id) Value;
- (NSColor*) colorValue;
- (NSString*) propertyListValue;
- (id) displayValue ;
@end
